class DM_HUD extends ChallengeHUD config(GameSetup_ClientConfig);

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic
#exec OBJ LOAD FILE=..\Textures\DanesSetupTex.utx PACKAGE=DanesSetupTex

//Custom client config variables:
//Splash variables:
var config bool		bUseSpreeSplashes;
var config float	ySplashBegin;
var config float	SplashFadeOutSpeed;
var config float	SplashScreenWidthUsage;
var config texture	FirstBloodTexture;
var config float	xFirstBlood,yFirstBlood;
var config texture	HeadShotTexture;
var config float	xHeadShot,yHeadShot;
var config texture	DoubleKillTexture;
var config float	xDoubleKill, yDoubleKill;
var config texture	TripleKillTexture;
var config float	xTripleKill, yTripleKill;
var config texture	MultiKillTexture;
var config float	xMultiKill, yMultiKill;
var config texture	UltraKillTexture;
var config float	xUltraKill, yUltraKill;
var config texture	MonsterKillTexture;
var config float	xMonsterKill, yMonsterKill;
var config texture	KillingSpreeTexture;
var config float	xKillingSpree, yKillingSpree;
var config texture	RampageTexture;
var config float	xRampage, yRampage;
var config texture	DominatingTexture;
var config float	xDominating, yDominating;
var config texture	UnstoppableTexture;
var config float	xUnstoppable, yUnstoppable;
var config texture	GodlikeTexture;
var config float	xGodlike, yGodlike;
var config texture	RevengeTexture;
var config float	xRevenge, yRevenge;
//Local time variables:
var config bool		bShowLocalTime;
var config string	LocalTimeX,
					LocalTimeY;
var config int		LocalTimeSize;
var config color	LocalTimeColor;

var bool 			bSaved;
var bool			bHeadShot;
var int				HeadShotColor;
var bool 			bFirstBlood;
var int				FirstBloodColor;
var bool			bDoubleKill;
var int				DoubleKillColor;
var bool			bMultiKill;
var int				MultiKillColor;
var bool			bUltraKill;
var int				UltraKillColor;
var bool			bMonsterKill;
var int				MonsterKillColor;
var bool			bKillingSpree;
var int				KillingSpreeColor;
var bool			bRampage;
var int				RampageColor;
var bool			bDominating;
var int				DominatingColor;
var bool			bUnstoppable;
var int				UnstoppableColor;
var bool			bGodlike;
var int				GodlikeColor;
var bool			bRevenge;
var int				RevengeColor;

var Texture Flag;
var Actor IpToCountry;
				
//Talk string holder:
var string TalkString;


var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

//var globalconfig int CrosshairCount;
//var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
//var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
//var globalconfig bool bUseTeamColor;
//var globalconfig byte Opacity;	// should be between 1 and 16
//var globalconfig float HUDScale, StatusScale, WeaponScale;
//var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

//var globalconfig string FontInfoClass;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

simulated function PostBeginPlay()
{
local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	
	Super.PostBeginPlay();
	
	SetTimer(1.0, True);
	
	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);	
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}

simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawStatus(Canvas Canvas)
{
local float XL, YL, UnitLength, XLength, Ypos;
local string HealthString, ArmorString;
local inventory Inv;
local int ArmorAmount, ShieldAmount, NumJumps, NumDamage, NumInvis;
local int NumElements;	//Used to keep track of how many elemets to draw
local float X,Y, Yelement;
local int i,s,ScoreLength,PH;
local string Score;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	
	//Health Icon, Bar and text info:
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Health', 64, 64, 0, 0, 256, 256);
	
	Canvas.SetPos(64, Canvas.ClipY - 48);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.HealthBarBW', 256, 32, 0, 0, 256, 32);
	
	UnitLength = 256 / 199; // 199 beeing hardcoded maxhealth!!
	PH = PlayerPawn(Owner).Health;
	if ( PH > 199 )
		PH = 199;
	XLength = PH * UnitLength;
	
	Canvas.SetPos(64, Canvas.ClipY - 48);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.HealthBarRed', XLength, 32, 0, 0, XLength, 32);
	
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	HealthString = String(PlayerPawn(Owner).Health)$"/199";
	Canvas.StrLen( HealthString, XL, YL );
	Ypos = 0.5 * (64 - YL);
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(196 - 0.5 * XL + 1, Canvas.ClipY - 63 + Ypos);
	Canvas.DrawText( HealthString, false );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(196 - 0.5 * XL, Canvas.ClipY - 64 + Ypos);
	Canvas.DrawText( HealthString, false );
	
	//Armor Icon, Bar and text info:
	Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - 64);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Shield', 64, 64, 0, 0, 256, 256);
	
	Canvas.SetPos(Canvas.ClipX - 64 - 256, Canvas.ClipY - 48);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.HealthBarBW', 256, 32, 0, 0, 256, 32);
	
	UnitLength = 256 / 150; // 150 beeing hardcoded max for both armor and shield!!
	
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.IsA('UT_Shieldbelt') )
			ShieldAmount += Inv.Charge;
		else if ( Inv.IsA('Thighpads') || Inv.IsA('Armor2') )
			ArmorAmount += Inv.Charge;
		else if ( Inv.IsA('UT_JumpBoots') )
			{
			NumJumps = Inv.Charge;
			NumElements++;
			}
		else if ( Inv.IsA('UDamage') )
			{
			NumDamage = UDamage(Inv).FinalCount;
			NumElements++;
			}
		else if ( Inv.IsA('UT_Invisibility') )
			{
			NumInvis = Inv.Charge;
			NumElements++;
			}
		}
		
	//NumDamage, NumInvis
	
	//Draw elements (JumpBoots,UDamage & Invisibility):	
	Yelement = Canvas.ClipY * 0.5 + 32 - NumElements * 64;
	
	//Jumpboots:
	if ( NumJumps > 0 )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64, Yelement);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Boots', 64, 64, 0, 0, 256, 256);
		Canvas.StrLen( NumJumps, XL, YL );
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL + 1, Yelement + 33 - 0.5 * YL);
		Canvas.DrawText( NumJumps, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Yelement + 32 - 0.5 * YL);
		Canvas.DrawText( NumJumps, false );
		Yelement += 64;
		}
	//UDamage:
	if ( NumDamage > 0 )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64, Yelement);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Damage', 64, 64, 0, 0, 256, 256);
		/* Nulled out as it doesnt work online, fix later!
		Canvas.StrLen( NumDamage, XL, YL );
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL + 1, Yelement + 33 - 0.5 * YL);
		Canvas.DrawText( NumDamage, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Yelement + 32 - 0.5 * YL);
		Canvas.DrawText( NumDamage, false );
		*/
		Yelement += 64;
		}
	//Invisibility:
	if ( NumInvis > 0 )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64, Yelement);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Invisibility', 64, 64, 0, 0, 256, 256);
		Canvas.StrLen( NumInvis, XL, YL );
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL + 1, Yelement + 33 - 0.5 * YL);
		Canvas.DrawText( NumInvis, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Yelement + 32 - 0.5 * YL);
		Canvas.DrawText( NumInvis, false );
		Yelement += 64;
		}
	if ( ArmorAmount > 0 && ShieldAmount == 0)
		{
		XLength = ArmorAmount * UnitLength;
		Canvas.SetPos(Canvas.ClipX - 64 - 256, Canvas.ClipY - 48);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.HealthBarBlue', XLength, 32, 0, 0, XLength, 32);
		ArmorString = String(ArmorAmount)$"/150";
		Canvas.StrLen( ArmorString, XL, YL );
		Ypos = 0.5 * (64 - YL);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL + 1, Canvas.ClipY - 63 + Ypos);
		Canvas.DrawText( ArmorString, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL, Canvas.ClipY - 64 + Ypos);
		Canvas.DrawText( ArmorString, false );
		}
	else if ( ShieldAmount > 0 )
		{
		XLength = ShieldAmount * UnitLength;
		Canvas.SetPos(Canvas.ClipX - 64 - 256, Canvas.ClipY - 48);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.HealthBarBlue', XLength, 32, 0, 0, XLength, 32);
		Canvas.SetPos(Canvas.ClipX - 64 - 256, Canvas.ClipY - 48);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.ShieldBar', XLength, 32, 0, 0, XLength, 32);
		ArmorString = String(ShieldAmount)$"/150";
		Canvas.StrLen( ArmorString, XL, YL );
		Ypos = 0.5 * (64 - YL);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL + 1, Canvas.ClipY - 63 + Ypos);
		Canvas.DrawText( ArmorString, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL, Canvas.ClipY - 64 + Ypos);
		Canvas.DrawText( ArmorString, false );
		}
	else
		{
		ArmorString = "0/150";
		Canvas.StrLen( ArmorString, XL, YL );
		Ypos = 0.5 * (64 - YL);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL + 1, Canvas.ClipY - 63 + Ypos);
		Canvas.DrawText( ArmorString, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64 - 128 - 0.5 * XL, Canvas.ClipY - 64 + Ypos);
		Canvas.DrawText( ArmorString, false );
		}
		
	//Frag info:
	Canvas.SetPos(0, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Skull', 64, 64, 0, 0, 256, 256);
	
	X = 64;
	Y = Canvas.ClipY - 128;
	
	Canvas.Style = ERenderStyle.STY_Masked;

	Score = string(int(PlayerPawn(Owner).PlayerReplicationInfo.Score));
	ScoreLength = len(Score);
	
	for (i=0;i<ScoreLength;i++)
		{
		if ( left(Score,1) == "0" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 0, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "1" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 34, 64, 88, 0, 34.0, 64.0);
			X += 34;
			}
		else if ( left(Score,1) == "2" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 153, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "3" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 242, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "4" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 331, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "5" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 420, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "6" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 509, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "7" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 598, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "8" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 687, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "9" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 776, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "-" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.Numbers', 58, 64, 865, 0, 58.0, 64.0);
			X += 58;
			}
		s += 1;
		Score = right(Score, ScoreLength - s);
		}
}

simulated function DrawAmmo(Canvas Canvas)
{
local float XL, YL, Ypos;
local int AmmoCount,MaxAmmo;
local string AmmoString;

	if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) )
		return;
	
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);
	
	AmmoCount = PawnOwner.Weapon.AmmoType.AmmoAmount;
	MaxAmmo = PawnOwner.Weapon.AmmoType.MaxAmmo;
	AmmoString = String(AmmoCount)$"/"$String(MaxAmmo);
	Canvas.StrLen( AmmoString, XL, YL );
	
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL - 64, Canvas.ClipY - 64);
	//Detect weapon and draw ammo icon accordingly:
	if ( PawnOwner.Weapon.IsA('enforcer') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Minigun', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('minigun2') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Minigun', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('PulseGun') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Pulse', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('ripper') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Ripper', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('ShockRifle') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Shock', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('SniperRifle') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Sniper', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('ut_biorifle') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Biogun', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('UT_Eightball') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Rocket', 64, 64, 0, 0, 64, 64);
	else if ( PawnOwner.Weapon.IsA('UT_FlakCannon') )
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo_Flak', 64, 64, 0, 0, 64, 64);
	else
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Ammo', 64, 64, 0, 0, 64, 64);
	Ypos = 0.5 * (64 - YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 64 + Ypos);
	Canvas.DrawText( AmmoString, false );
}

simulated function DrawFragCount(Canvas Canvas)
{
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
local float XL, YL, XOffset, YOffset;
local int MaxPlayers;
local string Spread;

	if ( (PawnOwner.PlayerReplicationInfo == None) || PawnOwner.PlayerReplicationInfo.bIsSpectator || (PlayerCount == 1) )
		return;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );

	// Rank String
	Canvas.StrLen(Rank$"/"$PlayerCount, XL, YL);

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos( 0, Canvas.ClipY - 192);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.Icon_Rank', 64, 64, 0, 0, 256, 256);
	Canvas.DrawColor = BlueColor * 0.1;
	Canvas.SetPos(26 - 0.5 * XL + 1, Canvas.ClipY - 156 - 0.5 * YL);
	Canvas.DrawText( Rank$"/"$PlayerCount, false );
	Canvas.DrawColor = BlueColor;
	Canvas.SetPos(26 - 0.5 * XL, Canvas.ClipY - 157 - 0.5 * YL);
	Canvas.DrawText( Rank$"/"$PlayerCount, false );

	// Spread String
	Canvas.SetPos(0, YOffset + YL);
	if (Lead > 0)
		{
		Spread = "+"$Lead;
		Canvas.DrawColor = GreenColor * 0.1;
		Canvas.SetPos(65, Canvas.ClipY - 156 - 0.5 * YL);
		Canvas.DrawText( Spread, false );
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(64, Canvas.ClipY - 157 - 0.5 * YL);
		Canvas.DrawText( Spread, false );
		}
	else
		{
		Spread = string(Lead);
		Canvas.DrawColor = RedColor * 0.1;
		Canvas.SetPos(65, Canvas.ClipY - 156 - 0.5 * YL);
		Canvas.DrawText( Spread, false );
		Canvas.DrawColor = RedColor;
		Canvas.SetPos(64, Canvas.ClipY - 157 - 0.5 * YL);
		Canvas.DrawText( Spread, false );
		}
}

simulated function DrawWeapons(Canvas Canvas)
{
}

simulated function DisplayProgressMessage( canvas Canvas )
{
local int i;
local float XL, YL, YOffset;
local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
		{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
			{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
			}
		}
	for (i=0; i<8; i++)
		{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];	
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
		}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawNewTalkFace(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen(TalkString, XL, YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX - 66 - XL - 64 - 16, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.textbubble_left', 16, 64, 0, 0, 16, 64);
	Canvas.SetPos(Canvas.ClipX - 66 - XL - 64, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.textbubble_right', XL, 64, 0, 0, 2, 64);
	Canvas.SetPos(Canvas.ClipX - 66 - 64, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.textbubble_right', 64, 64, 0, 0, 64, 64);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX - 66, 2);
	Canvas.DrawTile(FaceTexture, 64, 64, 0, 0, FaceTexture.USize, FaceTexture.VSize);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Canvas.ClipX - 130 - XL, 34 - 0.5 * YL);
	Canvas.DrawText(TalkString, False);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.SetPos(Canvas.ClipX - 130 - XL, 35 - 0.5 * YL);
	Canvas.DrawText(TalkString, False);
	
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{

}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
local float XL, YL, XPos, YPos, FadeValue;
local string Message;
local int M, i, j, k, XOverflow;
local float OldOriginX;
local string MyStr;
	
	//Save Config file to client
	if ( !bSaved )
		{
		bSaved = True;
		SaveConfig();
		}
	
	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bShowInfo )
		{
		if ( PlayerOwner.PlayerReplicationInfo.bAdmin )
			DrawAdminStuff(Canvas);
		else
			{
			ServerInfo.RenderInfo( Canvas );
			return;
			}
		}

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
		{
		//Drawspeecharea commented out as not needed, only draws background crappy blue boxy thingy
		//DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
			{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( 2, Canvas.OrgY );
				//Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
			}
		}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
								
				MyStr = CAPS(ShortMessageQueue[i].StringMessage);
				
				if ( InStr(MyStr, "BECAME A SERVER ADMINISTRATOR") != -1 )
					{
					if ( RI(PlayerPawn(Owner).PlayerReplicationInfo).bHiddenAdmin )
						{
						ShortMessageQueue[i].StringMessage = "";
						}
					}
				if ( ShortMessageQueue[i].StringMessage != "" )
					Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawNewTalkFace( Canvas );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				 
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
	
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			if ( !bHideAmmo )
				DrawAmmo(Canvas);
			
			// Draw Health/Armor status
			DrawStatus(Canvas);
			
			// Display Frag count
			DrawFragCount(Canvas);
		}
		// Team Game Synopsis
		if ( !bHideTeamInfo )
			DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	
	//Track localized messages for events and draw on HUD:
	if ( bUseSpreeSplashes )
		{
		TrackMessages(Canvas);
		DrawSplashMessages(Canvas);
		}
	
	//Draw local time:
	if ( bShowLocalTime )
		DrawLocalTime(Canvas);
	
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			{
			ClearMessage(ShortMessageQueue[i]);
			}
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	// Update the rank and spread.
	UpdateRankAndSpread();
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			{
			TalkString = Msg;
			return;
			}
		else
			TalkString = Msg;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

simulated function TrackMessages(Canvas Canvas)
{
local float XL, YL;
local int i;
local string MyStr;

	Canvas.Style = Style;
	//bHeadShot HeadShotColor
	for (i=0; i<10; i++)
		{
		if ( LocalMessages[i].StringMessage != "" )
			{
			MyStr = Caps(LocalMessages[i].StringMessage);
			
			//Canvas.StrLen(LocalMessages[i].StringMessage, XL, YL);
			//Canvas.SetPos(0, 50 + i*YL);
			//Canvas.DrawText(LocalMessages[i].StringMessage);
			
			//check for headshot:
			if ( InStr(MyStr, "HEAD SHOT") != -1 )
				{
				bHeadShot = True;
				HeadShotColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "FIRST BLOOD") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bFirstBlood = True;
				FirstBloodColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "DOUBLE KILL") != -1 )
				{
				bDoubleKill = True;
				DoubleKillColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "MULTI KILL") != -1 )
				{
				bMultiKill = True;
				MultiKillColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "ULTRA KILL") != -1 )
				{
				bUltraKill = True;
				UltraKillColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "M O N S T E R  K I L L") != -1 )
				{
				bMonsterKill = True;
				MonsterKillColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "IS ON A KILLING SPREE") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bKillingSpree = True;
				KillingSpreeColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "IS ON A RAMPAGE") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bRampage = True;
				RampageColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "IS DOMINATING") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bDominating = True;
				DominatingColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "IS UNSTOPPABLE") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bUnstoppable = True;
				UnstoppableColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "IS GODLIKE") != -1 && InStr(MyStr, Caps(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName)) != -1)
				{
				bGodlike = True;
				GodlikeColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			else if ( InStr(MyStr, "YOU GOT REVENGE") != -1 )
				{
				bRevenge = True;
				RevengeColor = 255;
				LocalMessages[i].StringMessage = "";
				}
			}
		}
}

simulated function DrawSplashMessages(Canvas Canvas)
{
local float ySpace, Xpos, Xscale;

	Canvas.Style = ERenderStyle.STY_Translucent;

	if ( bHeadShot && HeadShotColor > 0 )
		{
		Canvas.DrawColor.R = HeadShotColor;
		Canvas.DrawColor.G = HeadShotColor;
		Canvas.DrawColor.B = HeadShotColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xHeadShot; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xHeadShot * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin);
		Canvas.DrawTile(HeadShotTexture, xHeadShot * Xscale, yHeadShot * Xscale, 0, 0, xHeadShot, yHeadShot);
		HeadShotColor -= SplashFadeOutSpeed;
		if ( HeadShotColor <= 0 )
			{
			HeadShotColor = 255;
			bHeadShot = False;
			}
		ySpace += (yHeadShot * Xscale);
		}
	if ( bFirstBlood && FirstBloodColor > 0 )
		{
		Canvas.DrawColor.R = FirstBloodColor;
		Canvas.DrawColor.G = FirstBloodColor;
		Canvas.DrawColor.B = FirstBloodColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xFirstBlood; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xFirstBlood * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(FirstBloodTexture, xFirstBlood * Xscale, yFirstBlood * Xscale, 0, 0, xFirstBlood, yFirstBlood);
		FirstBloodColor -= SplashFadeOutSpeed;
		if ( FirstBloodColor <= 0 )
			{
			FirstBloodColor = 255;
			bFirstBlood = False;
			}
		ySpace += (yFirstBlood * Xscale);
		}
	if ( bDoubleKill && DoubleKillColor > 0 )
		{
		Canvas.DrawColor.R = DoubleKillColor;
		Canvas.DrawColor.G = DoubleKillColor;
		Canvas.DrawColor.B = DoubleKillColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xDoubleKill; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xDoubleKill * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(DoubleKillTexture, xDoubleKill * Xscale, yDoubleKill * Xscale, 0, 0, xDoubleKill, yDoubleKill);
		DoubleKillColor -= SplashFadeOutSpeed;
		if ( DoubleKillColor <= 0 )
			{
			DoubleKillColor = 255;
			bDoubleKill = False;
			}
		ySpace += (yDoubleKill * Xscale);
		}
	if ( bMultiKill && MultiKillColor > 0 )
		{
		Canvas.DrawColor.R = MultiKillColor;
		Canvas.DrawColor.G = MultiKillColor;
		Canvas.DrawColor.B = MultiKillColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xMultiKill; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xMultiKill * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(MultiKillTexture, xMultiKill * Xscale, yMultiKill * Xscale, 0, 0, xMultiKill, yMultiKill);
		MultiKillColor -= SplashFadeOutSpeed;
		if ( MultiKillColor <= 0 )
			{
			MultiKillColor = 255;
			bMultiKill = False;
			}
		ySpace += (yMultiKill * Xscale);
		}
	if ( bUltraKill && UltraKillColor > 0 )
		{
		Canvas.DrawColor.R = UltraKillColor;
		Canvas.DrawColor.G = UltraKillColor;
		Canvas.DrawColor.B = UltraKillColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xUltraKill; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xUltraKill * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(UltraKillTexture, xUltraKill * Xscale, yUltraKill * Xscale, 0, 0, xUltraKill, yUltraKill);
		UltraKillColor -= SplashFadeOutSpeed;
		if ( UltraKillColor <= 0 )
			{
			UltraKillColor = 255;
			bUltraKill = False;
			}
		ySpace += (yUltraKill * Xscale);
		}
	if ( bMonsterKill && MonsterKillColor > 0 )
		{
		Canvas.DrawColor.R = MonsterKillColor;
		Canvas.DrawColor.G = MonsterKillColor;
		Canvas.DrawColor.B = MonsterKillColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xMonsterKill; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xMonsterKill * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(MonsterKillTexture, xMonsterKill * Xscale, yMonsterKill * Xscale, 0, 0, xMonsterKill, yMonsterKill);
		MonsterKillColor -= SplashFadeOutSpeed;
		if ( MonsterKillColor <= 0 )
			{
			MonsterKillColor = 255;
			bMonsterKill = False;
			}
		ySpace += (yMonsterKill * Xscale);
		}
	if ( bKillingSpree && KillingSpreeColor > 0 )
		{
		Canvas.DrawColor.R = KillingSpreeColor;
		Canvas.DrawColor.G = KillingSpreeColor;
		Canvas.DrawColor.B = KillingSpreeColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xKillingSpree; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xKillingSpree * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(KillingSpreeTexture, xKillingSpree * Xscale, yKillingSpree * Xscale, 0, 0, xKillingSpree, yKillingSpree);
		KillingSpreeColor -= SplashFadeOutSpeed;
		if ( KillingSpreeColor <= 0 )
			{
			KillingSpreeColor = 255;
			bKillingSpree = False;
			}
		ySpace += (yKillingSpree * Xscale);
		}
	if ( bRampage && RampageColor > 0 )
		{
		Canvas.DrawColor.R = RampageColor;
		Canvas.DrawColor.G = RampageColor;
		Canvas.DrawColor.B = RampageColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xRampage; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xRampage * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(RampageTexture, xRampage * Xscale, yRampage * Xscale, 0, 0, xRampage, yRampage);
		RampageColor -= SplashFadeOutSpeed;
		if ( RampageColor <= 0 )
			{
			RampageColor = 255;
			bRampage = False;
			}
		ySpace += (yRampage * Xscale);
		}
	if ( bDominating && DominatingColor > 0 )
		{
		Canvas.DrawColor.R = DominatingColor;
		Canvas.DrawColor.G = DominatingColor;
		Canvas.DrawColor.B = DominatingColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xDominating; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xDominating * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(DominatingTexture, xDominating * Xscale, yDominating * Xscale, 0, 0, xDominating, yDominating);
		DominatingColor -= SplashFadeOutSpeed;
		if ( DominatingColor <= 0 )
			{
			DominatingColor = 255;
			bDominating = False;
			}
		ySpace += (yDominating * Xscale);
		}
	if ( bUnstoppable && UnstoppableColor > 0 )
		{
		Canvas.DrawColor.R = UnstoppableColor;
		Canvas.DrawColor.G = UnstoppableColor;
		Canvas.DrawColor.B = UnstoppableColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xUnstoppable; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xUnstoppable * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(UnstoppableTexture, xUnstoppable * Xscale, yUnstoppable * Xscale, 0, 0, xUnstoppable, yUnstoppable);
		UnstoppableColor -= SplashFadeOutSpeed;
		if ( UnstoppableColor <= 0 )
			{
			UnstoppableColor = 255;
			bUnstoppable = False;
			}
		ySpace += (yUnstoppable * Xscale);
		}
	if ( bGodlike && GodlikeColor > 0 )
		{
		Canvas.DrawColor.R = GodlikeColor;
		Canvas.DrawColor.G = GodlikeColor;
		Canvas.DrawColor.B = GodlikeColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xGodlike; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xGodlike * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(GodlikeTexture, xGodlike * Xscale, yGodlike * Xscale, 0, 0, xGodlike, yGodlike);
		GodlikeColor -= SplashFadeOutSpeed;
		if ( GodlikeColor <= 0 )
			{
			GodlikeColor = 255;
			bGodlike = False;
			}
		ySpace += (yGodlike * Xscale);
		}
	if ( bRevenge && RevengeColor > 0 )
		{
		Canvas.DrawColor.R = RevengeColor;
		Canvas.DrawColor.G = RevengeColor;
		Canvas.DrawColor.B = RevengeColor;
		Xscale = (Canvas.ClipX * SplashScreenWidthUsage) / xRevenge; 
		Xpos = Canvas.ClipX * 0.5 - 0.5 * (xRevenge * Xscale);
		Canvas.SetPos(Xpos, ySplashBegin + ySpace);
		Canvas.DrawTile(RevengeTexture, xRevenge * Xscale, yRevenge * Xscale, 0, 0, xRevenge, yRevenge);
		RevengeColor -= SplashFadeOutSpeed;
		if ( RevengeColor <= 0 )
			{
			RevengeColor = 255;
			bRevenge = False;
			}
		ySpace += (yRevenge * Xscale);
		}
	
	Canvas.Style = ERenderStyle.STY_Normal;
}

simulated function DrawLocalTime(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos;
local string Time;

	//Make Time string:
	if (Level.Hour < 10)
		Time = "0"$Level.Hour$":";
	else
		Time = Level.Hour$":";
	if (Level.Minute < 10 )
		Time = Time$"0"$Level.Minute;
	else
		Time = Time$Level.Minute;

	Canvas.Style = ERenderStyle.STY_Normal;
	
	//Get font size:
	if ( LocalTimeSize == 3 )
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	else if ( LocalTimeSize == 2 )
		Canvas.Font = MyFonts.GetMediumFont(Canvas.ClipX);
	else
		Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	
	Canvas.StrLen(Time, XL, YL);
	
	//Get X location:
	if ( LocalTimeX ~= "Center" )
		Xpos = Canvas.ClipX * 0.5 - 0.5 * XL;
	else if ( LocalTimeX ~= "Right" )
		Xpos = Canvas.ClipX - XL;
	else
		Xpos = 0;
	
	//Get Y location:
	if ( LocalTimeY ~= "Top" )
		Ypos = 0;
	else if ( LocalTimeY ~= "Bottom" )
		Ypos = Canvas.ClipY - YL;
	else
		Ypos = Canvas.ClipY * 0.5 - 0.5 * YL;
	
	Canvas.DrawColor = LocalTimeColor * 0.1;
	Canvas.SetPos(Xpos + 1, Ypos + 1);
	Canvas.DrawText(Time);
	Canvas.DrawColor = LocalTimeColor;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawText(Time);
}

simulated function DrawAdminStuff(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos,IDXpos,TeamXpos,CountryXpos,FlagScale;
local string Time;
local int i,ii;
local string ImportTexture;
local string IP;
local String Country, CountryFlag;
local bool bPlayerCutOut;

	//Draw title Frame:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);	
	Canvas.StrLen("Admin menu", XL, YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 400, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, 2 * YL, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 + 399, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, 2 * YL, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, 2);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, 1, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, YL);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, 1, 0, 0, 4, 4);
	
	//Draw title background:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, 3);
	Canvas.DrawTile(Texture'DanesSetupTex.SB.BlueGradient', 798, YL - 2, 0, 0, 128, 128);
	
	//Draw title:
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL + 1, 3);
	Canvas.DrawText("Admin menu", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, 2);
	Canvas.DrawText("Admin menu", False);
	
	//Draw categories:
	Ypos = YL;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);	
	Canvas.StrLen("IDxx", XL, YL);
	Xpos = Canvas.ClipX * 0.5 - 398;
	IDXpos = Xpos + 160;
	TeamXpos = IDXpos + XL;
	Canvas.StrLen("Teamxx", XL, YL);
	CountryXpos = TeamXpos + XL;
	//Draw background:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = TurqColor * 0.15;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, Ypos + 1);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, YL - 1, 0, 0, 4, 4);
	//Draw PlayerName category title:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos( Xpos + 1, Ypos + 1);
	Canvas.DrawText("Playername", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos, Ypos);
	Canvas.DrawText("Playername", False);
	//Draw ID category title:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos( IDXpos + 1, Ypos + 1);
	Canvas.DrawText("ID", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( IDXpos, Ypos);
	Canvas.DrawText("ID", False);
	//Draw Team category title:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos( TeamXpos + 1, Ypos + 1);
	Canvas.DrawText("Team", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( TeamXpos, Ypos);
	Canvas.DrawText("Team", False);
	//Draw Country category title:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos( CountryXpos + 1, Ypos + 1);
	Canvas.DrawText("Country", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( CountryXpos, Ypos);
	Canvas.DrawText("Country", False);
	//Draw category frame bottom line:
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, Ypos + YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, 1, 0, 0, 4, 4);
	Ypos += YL;
	
	//list players:
	for (ii=0;PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii] != None;ii++)
		{
		if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].PlayerName != "Player")
			{
			if ( bPlayerCutOut )
				i = ii - 1;
			else
				i = ii;
			//Draw background:
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.DrawColor = TurqColor * 0.15;
			Canvas.SetPos( Canvas.ClipX * 0.5 - 399, Ypos + i*YL + 1);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, YL - 1, 0, 0, 4, 4);
			//Draw player name:
			Canvas.DrawColor = WhiteColor;	//change so writes name in team color
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetPos(Xpos, Ypos + i*YL);
			Canvas.DrawText(PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].PlayerName);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos( Canvas.ClipX * 0.5 - 400, Ypos + i*YL);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
			Canvas.SetPos( Canvas.ClipX * 0.5 + 399, Ypos + i*YL);
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
			//Draw player ID:
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos( IDXpos - 2, Ypos + i*YL );
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
			Canvas.SetPos(IDXpos, Ypos + i*YL);
			Canvas.DrawText(PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].PlayerID);
			//Draw player Team:
			Canvas.SetPos( TeamXpos - 2, Ypos + i*YL );
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
			Canvas.SetPos(TeamXpos, Ypos + i*YL + 0.125 * YL);
			if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].Team == 0 )
				{
				Canvas.DrawColor = RedColor;
				Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', CountryXpos - TeamXpos - 4, 0.8 * YL, 0, 0, 4, 4);
				}
			else if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].Team == 1 )
				{
				Canvas.DrawColor = BlueColor;
				Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', CountryXpos - TeamXpos - 4, 0.8 * YL, 0, 0, 4, 4);
				}
			else if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].Team == 2 )
				{
				Canvas.DrawColor = GreenColor;
				Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', CountryXpos - TeamXpos - 4, 0.8 * YL, 0, 0, 4, 4);
				}
			else if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].Team == 3 )
				{
				Canvas.DrawColor = GoldColor;
				Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', CountryXpos - TeamXpos - 4, 0.8 * YL, 0, 0, 4, 4);
				}
			else
				{
				Canvas.DrawColor.R = 0;
				Canvas.DrawColor.G = 0;
				Canvas.DrawColor.B = 0;
				Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', CountryXpos - TeamXpos - 4, 0.8 * YL, 0, 0, 4, 4);
				}
			//Draw player Country:
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos( CountryXpos - 2, Ypos + i*YL );
			Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
			Canvas.SetPos(CountryXpos, Ypos + i*YL + 1);
			FlagScale = (YL - 2) / 32;
			if ( !PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii].bIsABot )
				{
				if ( RI(PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii]).Country != "" && Level.NetMode != NM_Standalone )
					{
					CountryFlag = Right(RI(PlayerPawn(Owner).GameReplicationInfo.PRIArray[ii]).Country,2);
					ImportTexture = "GameSetup2k14_beta2.Flags."$CountryFlag;
					}
				else
					{
					ImportTexture = "GameSetup2k14_beta2.Flags.NoFlag";
					}
				}
			else
				{
				ImportTexture = "GameSetup2k14_beta2.Flags.BotFlag";
				}
			Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
			if ( Flag != none )
				{
				Canvas.DrawTile(Flag, 48 * FlagScale, 32 * FlagScale, 0, 0, 48, 32);
				}
			}
		else
			bPlayerCutOut = True;
		}
	Ypos = Canvas.CurY + YL;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, Ypos);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 798, 1, 0, 0, 4, 4);	
}


defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
	bUseSpreeSplashes=True
	FirstBloodTexture=Texture'DanesSetupTex.Sprees.FirstBlood'
	HeadShotTexture=Texture'DanesSetupTex.Sprees.HeadShot'
	DoubleKillTexture=Texture'DanesSetupTex.Sprees.DoubleKill'
	TripleKillTexture=Texture'DanesSetupTex.Sprees.TripleKill'
	MultiKillTexture=Texture'DanesSetupTex.Sprees.MultiKill'
	UltraKillTexture=Texture'DanesSetupTex.Sprees.UltraKill'
	MonsterKillTexture=Texture'DanesSetupTex.Sprees.MonsterKill'
	KillingSpreeTexture=Texture'DanesSetupTex.Sprees.KillingSpree'
	RampageTexture=Texture'DanesSetupTex.Sprees.Rampage'
	DominatingTexture=Texture'DanesSetupTex.Sprees.Dominating'
	UnstoppableTexture=Texture'DanesSetupTex.Sprees.Unstoppable'
	GodlikeTexture=Texture'DanesSetupTex.Sprees.Godlike'
	RevengeTexture=Texture'DanesSetupTex.Sprees.Revenge'
	xFirstBlood=800
	yFirstBlood=64
	xHeadShot=680
	yHeadShot=64
	xDoubleKill=774
	yDoubleKill=64
	xTripleKill=682
	yTripleKill=64
	xMultiKill=648
	yMultiKill=64
	xUltraKill=650
	yUltraKill=64
	xMonsterKill=912
	yMonsterKill=64
	xKillingSpree=876
	yKillingSpree=64
	xRampage=572
	yRampage=64
	xDominating=800
	yDominating=64
	xUnstoppable=888
	yUnstoppable=64
	xGodlike=526
	yGodlike=64
	xRevenge=600
	yRevenge=64
	ySplashBegin=96
	SplashFadeOutSpeed=1
	SplashScreenWidthUsage=0.75
	bShowLocalTime=True
	LocalTimeX="Left"
	LocalTimeY="Center"
	LocalTimeSize=1
	LocalTimeColor=(R=255,G=255,B=255)
}
